import h5py
import numpy as np
import sys
sys.path.insert(0,'../caffe_gpu/python/')
from caffe import layers as cl
import caffe.proto.caffe_pb2 as caffe_pb2
import google.protobuf as pb
import caffe
net = caffe_pb2.NetParameter()


def scale(p):
	return 1<<(15-p)

def RP(x,p):
	y=int(x*scale(p))
	if abs(y)>(1<<15):
	return y

with open('lenet.prototxt', 'r') as f:
#with open('nin.prototxt', 'r') as f:
			pb.text_format.Merge(f.read(), net)
test_types=['Convolution','InnerProduct']
CaffeNet = caffe.Net('lenet.prototxt','lenet.caffemodel',caffe.TEST)
#CaffeNet = caffe.Net('nin.prototxt','nin.caffemodel',caffe.TEST)
act_prec=[1,3,3,3]
wgt_prec=[0,0,0,0]
#act_prec=[10,10,9,12,12,11,11,11,10,10,10,9]
#wgt_prec=[0,1,1,0,0,0,0,0,0,0,0,0]
layers=[]
w_set={}
b_set={}
for x in net.layer:
	if x.type in test_types:
		w_set.update({str(x.name):CaffeNet.params[str(x.name)][0].data})
		b_set.update({str(x.name):CaffeNet.params[str(x.name)][1].data})
		print(x.name)
		layers.append(str(x.name))


print layers
		
for x in net.layer:
	print(str(x.name))
	if x.type == 'Convolution':
		for i in range(w_set[str(x.name)].shape[0]):
			b_set[str(x.name)][i]=RP(b_set[str(x.name)][i],act_prec[layers.index(str(x.name))])
                	CaffeNet.params[str(x.name)][1].data[i]=1.0*b_set[str(x.name)][i]/scale(act_prec[layers.index(str(x.name))])
		print("\tbias done")
		for i in range(w_set[str(x.name)].shape[0]):
			for j in range(w_set[str(x.name)].shape[1]):
				for k in range(w_set[str(x.name)].shape[2]):
					for l in range(w_set[str(x.name)].shape[3]):
						w_set[str(x.name)][i][j][k][l]=RP(w_set[str(x.name)][i][j][k][l],wgt_prec[layers.index(str(x.name))])
                				CaffeNet.params[str(x.name)][0].data[i][j][k][l]=1.0*w_set[str(x.name)][i][j][k][l]/scale(wgt_prec[layers.index(str(x.name))])
		print("\tweight done")
	if x.type == 'InnerProduct':
		for i in range(w_set[str(x.name)].shape[0]):
			b_set[str(x.name)][i]=RP(b_set[str(x.name)][i],act_prec[layers.index(str(x.name))])
                	CaffeNet.params[str(x.name)][1].data[i]=1.0*b_set[str(x.name)][i]/scale(act_prec[layers.index(str(x.name))])
		print("\tbias done")
		for i in range(w_set[str(x.name)].shape[0]):
			for j in range(w_set[str(x.name)].shape[1]):
				w_set[str(x.name)][i][j]=RP(w_set[str(x.name)][i][j],wgt_prec[layers.index(str(x.name))])
	                	CaffeNet.params[str(x.name)][0].data[i][j]=1.0*w_set[str(x.name)][i][j]/scale(wgt_prec[layers.index(str(x.name))])
		print("\tweight done")




for x in net.layer:
	if x.type in ['Convolution','InnerProduct']:
		w_set[str(x.name)]=w_set[str(x.name)].astype(np.int16)
		b_set[str(x.name)]=b_set[str(x.name)].astype(np.int16)
#CaffeNet.save("lenet_mod.caffemodel")
CaffeNet.save("nin_mod.caffemodel")
#print(w_set)
#print(b_set)
np.save("lenet_w.npy",w_set)
np.save("lenet_b.npy",b_set)
#np.save("nin_w.npy",w_set)
#np.save("nin_b.npy",b_set)
f.close()
