import h5py
import numpy as np
import sys
sys.path.insert(0,'../caffe_gpu/python/')
from caffe import layers as cl
import caffe.proto.caffe_pb2 as caffe_pb2
import google.protobuf as pb
import caffe

def scale(p):
	return 1<<(15-p)

def RP(x,p):
	y=int(x*scale(p))
	return y

lenet_act_prec=[1,3,3,3]
lenet_wgt_prec=[0,0,0,0]
nin_act_prec=[10,10,9,12,12,11,11,11,10,10,10,9]
nin_wgt_prec=[0,1,1,0,0,0,0,0,0,0,0,0]

caffe.set_device(0)
caffe.set_mode_gpu()
LeNet = caffe.Net('lenet_red.prototxt','lenet.caffemodel',caffe.TEST)
NiN = caffe.Net('nin_red.prototxt','nin.caffemodel',caffe.TEST)


LeNet.forward()
lenet_input=np.array(LeNet.blobs['data'].data)
lenet_output=np.array(LeNet.blobs['ip2'].data)



NiN.forward()
nin_input=np.array(NiN.blobs['data'].data)
nin_output=np.array(NiN.blobs['pool4'].data)

for i in range(lenet_input.shape[0]):
	for j in range(lenet_input.shape[1]):
		for k in range(lenet_input.shape[2]):
			for l in range(lenet_input.shape[3]):
				lenet_input[i][j][k][l]=RP(lenet_input[i][j][k][l],1)

for i in range(lenet_output.shape[0]):
	for j in range(lenet_output.shape[1]):
		lenet_output[i][j]=RP(lenet_output[i][j],7)


for i in range(nin_input.shape[0]):
	for j in range(nin_input.shape[1]):
		for k in range(nin_input.shape[2]):
			for l in range(nin_input.shape[3]):
				nin_input[i][j][k][l]=RP(nin_input[i][j][k][l],10)

for i in range(nin_output.shape[0]):
	for j in range(nin_output.shape[1]):
		nin_output[i][j]=RP(nin_output[i][j],7)

lenet_input=lenet_input.astype(np.int16)
lenet_output=lenet_output.astype(np.int16)

nin_input=nin_input.astype(np.int16)
nin_output=nin_output.astype(np.int16)

np.save("lenet_input.npy",lenet_input)
np.save("lenet_output.npy",lenet_output)
np.save("nin_input.npy",nin_input)
np.save("nin_output.npy",nin_output)
