#!/bin/sh -x

#
# Step 1: setup INSTALLDIR for packages
#
# default INSTALLDIR is $HOME/cs161
#
# Add the bin directory in INSTALLDIR to your shell's search path before running
# this script. Users of sh or bash should do something like this: 
# export PATH=$INSTALLDIR/bin:$PATH 

INSTALLDIR=$HOME/cs161

# For ECF machines
# INSTALLDIR=/extra/projects/cs161

# For ECE workstation machines
# INSTALLDIR=/cad2/ece344f/cs161

SHELL=/bin/sh
export SHELL
#
# Step 2: install gcc-3.4
#
# Unfortunately, we need to use gcc-3.4 (not the latest gcc-4 series) 
# to compile the GCC MIPS compiler below.
#
# sudo apt-get install gcc-3.4
export CC=/usr/bin/gcc-3.4
# Update: gcc 4.4 seems to work fine
export CC=/usr/bin/gcc

if [ ! -f "$CC" ]; then
    echo "Install $CC by running ./install-gcc34.sh"
    exit 1;
fi

export CPPFLAGS=-D_FORTIFY_SOURCE=0
#
# Step 3. install binutils
#
# This will result in the creation of the directories $INSTALLDIR/tools and
# $INSTALLDIR/bin. The former will contain the actual compiled utilities, and
# the latter will contain symbolic links to the compiled binaries.

tar -xzf os161-binutils.tar.gz; \
cd cs161-binutils-1.4; \
./toolbuild.sh --cs161dir=$INSTALLDIR; \
cd ..

unset CPPFLAGS
#
# Step 4: Install the GCC MIPS Cross-Compiler
#
tar -xzf os161-gcc.tar.gz; \
cd cs161-gcc-1.4; \
./toolbuild.sh --cs161dir=$INSTALLDIR; \
cd ..

#
# Step 5: Install GDB
#
tar -xzf os161-gdb.tar.gz; \
cd cs161-gdb-1.4; \
./toolbuild.sh --cs161dir=$INSTALLDIR; \
cd ..

#
# Step 6: Install sys161 simulator
#
tar -xzf sys161-1.14.tar.gz; \
cd sys161-1.14; \
./configure --installdir=$INSTALLDIR/bin --docdir=$INSTALLDIR/man mipseb; \
make; \
make install; \
cd ..
